var G2_STOPPED    = 0;
var G2_PLAYING    = 1;

var G2_CONTACTING = -1;
var G2_BUFFERING  = -1;
var G2_PAUSED     = -1;
var G2_SEEKING    = -1;

var G2_inNetscape45 = (navigator.appName == 'Netscape' && parseInt(navigator.appVersion) < 5);
var G2_inIe4 = (navigator.appName == "Microsoft Internet Explorer" && parseInt(navigator.appVersion) >= 4);
var G2_inNetscape6 = (navigator.appName == 'Netscape' && parseInt(navigator.appVersion) >= 5);
var G2_unsupportedBrowser = (!(G2_inNetscape45 || G2_inIe4 || G2_inNetscape6));

function G2_getPlayState(clipName, doc)
{
	if (doc == null) doc = document;
	var clipRef = G2_checkClipRef(clipName, "G2_getPlayState", doc);
	if (clipRef.IsPlaying())
	{
		return G2_PLAYING;
	}
	else
	{
		return G2_STOPPED;
	}
}

function G2_isPlaying(clipName, doc)
{
	if (doc == null) doc = document;
	var clipRef = G2_checkClipRef(clipName, "G2_isPlaying", doc);
	return clipRef.IsPlaying();
}

function G2_getSource(clipName, doc)
{
	if (doc == null) doc = document;
	var clipRef = G2_checkClipRef(clipName, "G2_getSource", doc);
	return cleanupURL(clipRef.TGetProperty("/",15));
}

function G2_setSource(clipName, url, doc)
{
	if (doc == null) doc = document;
	var clipRef = G2_checkClipRef(clipName, "G2_setSource", doc);
	
	// Need to strip filename off end of url
	var index = url.lastIndexOf("/");
	if (index >= 0)
	{
		url = url.slice(index+1,url.length);
	}
	// Need to get folder url of last clip
	// loaded into the Flash object.
	var strBase = G2_getSource(clipRef);
	index = strBase.lastIndexOf("/");
	if (index >= 0)
	{
		strBase = strBase.slice(0,index);
	}
	// Concatenate folder url and url to
	// use as the new source location.
	url = strBase + "/" + url;
	
	clipRef.LoadMovie(0, url);
}

function G2_getLength(clipName, doc)
{
	if (doc == null) doc = document;
	var clipRef = G2_checkClipRef(clipName, "G2_getLength", doc);
	if (G2_inIe4)
	{
		return Math.round(clipRef.TotalFrames/12*1000);
	}
	else
	{
		return Math.round(clipRef.TotalFrames()/12*1000);
	}
}

function G2_setSourcePlay(clipName, url, doc)
{
	if (doc == null) doc = document;
	var clipRef = G2_checkClipRef(clipName, "G2_setSourcePlay", doc);
	G2_setSource(clipRef,url);
	G2_play(clipRef);
}

var FP_ClipHash = new HashTable();
function G2_play(clipName, doc)
{
	if (doc == null) doc = document;
	var clipRef = G2_checkClipRef(clipName, "G2_play", doc);
	_G2_currentClip = clipRef;
	if (typeof(clipName) == "object")
	{
		clipName = clipName.name;
	}
	FP_ClipHash.put(clipName,clipRef);
	FP_stopAllClips();
	tryToPlay();
}

var _G2_currentClip = null;
function tryToPlay()
{
	if (_G2_currentClip.PercentLoaded() == 100)
	{
		_G2_currentClip.Play();
	}
	else
	{
		setTimeout("tryToPlay()",250);
	}
}

function G2_stop(clipName, doc)
{
	if (doc == null) doc = document;
	var clipRef = G2_checkClipRef(clipName, "G2_stop", doc);
	clipRef.GotoFrame(0);
	clipRef.StopPlay();
}

function G2_pause(clipName, doc)
{
	if (doc == null) doc = document;
	var clipRef = G2_checkClipRef(clipName, "G2_stop", doc);
	clipRef.StopPlay();
}

function G2_getPosition(clipName, doc)
{
	if (doc == null) doc = document;
	var clipRef = G2_checkClipRef(clipName, "G2_getPosition", doc);
	return Math.round(clipRef.TCurrentFrame("/")/12*1000);
}

function G2_setPosition(clipName, pos, doc)
{
	if (doc == null) doc = document;
	var clipRef = G2_checkClipRef(clipName, "G2_setPosition", doc);
	clipRef.GotoFrame(pos*12/1000);
}

function G2_checkClipRef(clipRef, functionName, doc)
{
	if (doc == null) doc = document;
	if (arguments.length < 3)
	{
		doc = document;
	}

	if ( typeof(clipRef) == 'string' )
	{
		return G2_getClipRef(clipRef, doc);
	}
	else
	{
		if ( typeof(clipRef) != 'object')
		{
			return null;
		}
	}
	return clipRef;
}

function G2_getClipRef(clipName, doc)
{
	recCount = 0;
	if (arguments.length < 2)
	{
		doc = document;
	}
	
	return G2_getClipRef2(clipName, doc);
}

function G2_getClipRef2(clipName, doc)
{
	var clipRef = null;	
	
	// Base Case 1
	if (navigator.appName == "Microsoft Internet Explorer") 
	{
		clipRef = eval("doc." + clipName);
		return clipRef;
	}

	// Base Case 2
	if (recCount++ >= 100) 
	{
		return null;
	}	

	// Base Case 3
	if (doc.embeds.length > 0) // look for embed in the document	
	{
		if (doc.embeds[clipName] != null) 
		{
			clipRef = doc.embeds[clipName];
			return clipRef;
		}			
	}	

	if (inNetscape6)
	{
		return doc.getElementById(clipName);
	}
	else
	{	
		// Possible Recursion	
		for (var i=0;i<doc.layers.length;i++) // for each layer in the document
		{
			//alert("You have found layer: " + doc.layers[i].id);
			if (doc.layers[i].document.embeds.length > 0)
			{
				if (doc.layers[i].document.embeds[clipName] != null) 
				{
					clipRef = doc.layers[i].document.embeds[clipName];
					return clipRef;
				}
			}
			if (doc.layers[i].document.layers.length > 0) 
				if ( (clipRef = G2_getClipRef2(clipName,doc.layers[i].document)) != null ) 
					break;
		}
	}
	
	return clipRef;
}

// Not implemented
function G2_setVolume()
{
}

// Not implemented
function G2_getVolume()
{
	return 100;
}

function cleanupURL(url)
{
	url = url + "";
	for (var i=0;i<url.length;i++)
	{
		if (url.charCodeAt(i) < 32 || url.charCodeAt(i) > 126)
		{
			url = url.slice(0,i) + url.slice(i+1,url.length);
		} 
		else if (url.charAt(i) == "\\")
		{
			url = url.slice(0,i) + "/" + url.slice(i+1,url.length);
		}
	}
	return url;
}

function FP_stopAllClips()
{
	if (FP_ClipHash != null)
	{
		var keyArray = FP_ClipHash.getKeys();
		for (var i=0;i<keyArray.length;i++)
		{
			G2_stop(keyArray[i]);
		}
	}

	if (window.audioReference != null)
	{
		window.audioReference.stop();
	}
}

